/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("Mach3IN.js");

function Mach3LaserIN(cadDocumentInterface, camDocumentInterface) {
    Mach3IN.call(this, cadDocumentInterface, camDocumentInterface);

    this.fileExtensions = [ "nc" ];

    this.decimals = 4;
    this.unit = RS.Millimeter;

    // disable all Z moves:
    this.firstLinearMoveZ = [];
    this.linearMoveZ = [];
    this.rapidMoveZ = [];

    // stop cutting at tab:
    this.stopAtTab = true;

    this.toolHeader = [];

    // before every contour or pass, switch on laser:
    this.zPassHeader = [
        "[N] S255 M03"
    ];

    // after every contour or pass, switch off laser:
    this.zPassFooter = [
        "[N] S0"
    ];
}

Mach3LaserIN.prototype = new Mach3IN();

Mach3LaserIN.displayName = "Mach3 Laser (G41/G42) [in]";

