/**
 * This file is not part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 
 
 # VERSION
    001        2018-08-10    wd        erster Entwurf für den Essi-Postprozessor
    002        2018-08-17    wd        Korrektur an den Vorzeichen, erst einmal über "formatValue"
                                       Korrektur an den Vollkreisen
                                       Als Anfahrwegtyp können auch Radien, die nicht vom Zentrum beginnen, verwendet werden (outputOffsetPath)
    003        2018-08-18    wd        pointMoveZ für Punktsignieren verwendet: AF 110/111 (Dient als Körner Ersatz zum Bohren)
    004        2018-09-05    wd        Vor "lead out" wird die Höhenautomatik abgeschaltet
 */

// Include definition of class GCodeBase:
include("GCodeBase.js");

// Constructor:
function EssiPlasmaMM(cadDocumentInterface, camDocumentInterface) {
     GCodeBase.call(this, cadDocumentInterface, camDocumentInterface);

    this.decimals = 0;
    this.outputOffsetPath = true;

//    this.splitFullCircles = true;

    this.registerVariable("xPosition",           "X",                    true, "", "DEFAULT",  { factor: 10, sign: true  });
    this.registerVariable("yPosition",           "Y",                    true, "", "DEFAULT",  { factor: 10, sign: true  });
    this.registerVariable("zPosition",           "Z",                    true, "", "DEFAULT",  { factor: 10, sign: true  });
    this.registerVariable("iArcCenterInc",       "I",                    true, "", "DEFAULT",  { factor: 10, sign: true  });
    this.registerVariable("jArcCenterInc",       "J",                    true, "", "DEFAULT",  { factor: 10, sign: true  });
    this.registerVariable("iArcCenterAbs",       "IA",                   true, "", "DEFAULT",  { factor: 10, sign: true  });
    this.registerVariable("jArcCenterAbs",       "JA",                   true, "", "DEFAULT",  { factor: 10, sign: true  });

    this.registerVariable("direction",           "direction",            true, "", "DEFAULT", "DEFAULT");
    this.registerVariable("postprozessor",       "POSTPROZESSOR",        true, "", "DEFAULT", "DEFAULT");

    this.postprozessor =  "EssiPlasmaMM V004";

    this.rapidMove = [
        "5",
        "[X!][Y!]",
        "6"
        ];

    this.rapidMoveZ =[];

     // linear moves:
    this.firstLinearMove =  ["[X!][Y!]"];
    this.linearMove =["[X!][Y!]"]

    // linear Z moves:
//    this.firstLinearMoveZ = ["53"];        // auch bei Eilgangstrecke aktiv
    this.linearMoveZ = ["54"];

     // point moves for drilling:
    this.firstPointMoveZ = [];
    this.pointMoveZ = ["110",
            "111"];

    this.header = [
        "3",
        "QCAD/CAM",
        "[FILENAME]",
        "[POSTPROZESSOR]",
        "4",
        "81"];
    this.footer = [];

    // header / footer before / after tool change:
    this.toolHeader = [];
    this.toolFooter = [];

    // circular moves:
    this.firstArcCWMove = ["[X!][Y!][IA!][JA!]-"];
    this.arcCWMove =  ["[X!][Y!][IA!][JA!]-"];
    this.firstArcCCWMove = ["[X!][Y!][IA!][JA!]+"];
    this.arcCCWMove = ["[X!][Y!][IA!][JA!]+"];


    this.linearMoveCompensationLeft = ["[X!][Y!]"];
    this.linearMoveCompensationRight = ["[X!][Y!]"];
    this.linearMoveCompensationOff = ["COMP OFF 48","[X!][Y!]"];

    this.fileExtensions = ["mpg"];
    this.unit = RS.Millimeter;
}

// Configuration is derived from ESSIBase:
 EssiPlasmaMM.prototype = new GCodeBase();
// Display name shown in user interface:
EssiPlasmaMM.displayName = "ESSI Plasma [mm]";

EssiPlasmaMM.prototype.formatValue = function(value, decimals, options) {
    var ret = GCodeBase.prototype.formatValue.call(this, value, decimals, options);
    if (ret==="0") {
        ret = "+0";
    }
    return ret;
};

EssiPlasmaMM.prototype.writeEntity = function() {

    var leadOut = this.getEntityOptionBool(this.currentEntity, "CamLeadOut", false) ||
                  this.getEntityOptionBool(this.currentEntity, "CamOvercutOut", false);

    if (leadOut) {
        //this.writeLinearMoveCompensationOff();
        this.writeLine("---> 48");
    }

    // direction
    if(this.getDirection() == 1){
        this.direction = "29";
    }
    else if(this.getDirection() == 2){
        this.direction = "29";
    }

    // Z-Achse für Prozess-Start
    if(this.zPosition >=0){
        this.firstLinearMoveZ =["54"];
    }
    else{
        this.firstLinearMoveZ = [
            "[direction]",
            "53"
        ];
    }

    GCodeBase.prototype.writeEntity.call(this);
}; 
