/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("AdtHc4500.js");

/**
 * Configuration for AdtHc4500 controllers.
 * Output in Millimeters.
 */
function AdtHc4500MM(documentInterface, camDocumentInterface) {
    AdtHc4500.call(this, documentInterface, camDocumentInterface);

    this.decimals = 3;
    this.unit = RS.Millimeter;

    this.header = [
        "G92 X0. Y0.",
        "G21",
        "G90",
    ];
}

AdtHc4500MM.prototype = new AdtHc4500();
AdtHc4500MM.displayName = "ADT HC4500 (Offset) [mm]";
