/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

function Tnc145MM(cadDocumentInterface, camDocumentInterface) {
    GCodeBase.call(this, cadDocumentInterface, camDocumentInterface);

    this.decimals = 3;
    this.options = {
        sign: true,
        decimalSeparator: ",",
        trailingZeroes: true
    };

    this.unit = RS.Millimeter;
    this.fileExtensions = [ "nc" ];
    this.splitFullCircles = true;
    this.lineNumber = 0;
    this.lineNumberIncrement = 1;
    this.outputOffsetPath = true;

    this.header = [
        "[N#] BEGIN PGM [PROGRAM_NAME] MM",
        "[N#] L [ZS!] R0 F9999 M"
    ];
    this.footer = [
        "[N#] L [ZS!] R0 F9999 M30",
        "[N#] END PGM [PROGRAM_NAME] MM"
    ];

    this.toolHeader = [
        "[N#] TOOL DEF [T#] L+0,000 R+0,000",
        "[N#] TOOL CALL [T#] Z [S]"
    ];

    this.rapidMove = [
        "[N#] L [X] [Y] R0 F9999 M"
    ];
    this.rapidMoveZ = [
        "[N#] L [Z] R0 F9999 M"
    ];

    this.linearMove = [
        "[N#] L [X] [Y] R0 [F] M"
    ];
    this.linearMoveZ = [
        "[N#] L [Z] R0 [F] M"
    ];

    this.arcCWMove = [
        "[N#] CC X[IA#] X[JA#]",
        "[N#] C [X] [Y] DR- [F]"
    ];

    this.arcCCWMove = [
        "[N#] CC X[IA#] Y[JA#]",
        "[N#] C [X] [Y] DR+ [F]"
    ];

    this.firstLinearMove = this.linearMove;
    this.firstLinearMoveZ = this.linearMoveZ;
    this.firstArcCWMove = this.arcCWMove;
    this.firstArcCCWMove = this.arcCCWMove;

    this.linearMoveCompensationLeft = [];
    this.linearMoveCompensationRight = [];
    this.linearMoveCompensationOff = [];

}

Tnc145MM.prototype = new GCodeBase();
Tnc145MM.displayName = "Heidenhain TNC145 [mm]";
