/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

/**
 * Switch laser on / off, disable tool changes.
 */
function FlskF2000IN(documentInterface, camDocumentInterface) {
    GCodeBase.call(this, documentInterface, camDocumentInterface);

    this.fileExtensions = [ "txt" ];

    this.outputOffsetPath = true;

    // disable line numbers:
    this.empty = "";
    this.registerVariable("empty", "N", true, "", 0);

    // disable all Z moves:
    this.rapidMoveZ = [];
    this.firstLinearMoveZ = [];
    this.linearMoveZ = [];
    this.firstPointMoveZ = [];
    this.pointMoveZ = [];

    // stop cutting at tab:
    this.stopAtTab = true;

    // disable tool changes:
    this.toolHeader = [];

    this.decimals = 3;
    this.unit = RS.Inch;

    this.header = [
        "%",      // top of program
        "G70",    // unknown
        "G90",    // absolute mode
    ];

    this.footer = [
        "M02",    // program end
    ];

    this.zPassHeader = [
        "M07",     // start cutting cycle
    ];
    this.zPassFirstHeader = this.zPassHeader;

    this.zPassFooter = [
        "M08",    // end cutting cycle
    ];
    this.zPassLastFooter = this.zPassFooter;
}

FlskF2000IN.prototype = new GCodeBase();
FlskF2000IN.displayName = "FLSK F2000 (Offset) [in]";

FlskF2000IN.prototype.getToolTypeTitle = function(toolType) {
    if (isString(toolType)) {
        toolType = parseInt(toolType);
    }

    // use mill as laser:
    switch (toolType) {
    case Cam.ToolType.Mill:
        return qsTr("Laser");
    default:
        return undefined;
    }
};

FlskF2000IN.prototype.postInitDialog = function(obj, dialog, di, block) {
    var w;

    // disable spindle speed / plunge rate:
    if (dialog.objectName==="CamProfileToolpathDialog") {
        w = dialog.findChild("CamPlungeRate_Label");
        w.visible = false;
        w = dialog.findChild("CamPlungeRate");
        w.visible = false;

        // only display "passes" of cutting depths group:
        w = dialog.findChild("CuttingDepths_Group");
        w.visible = false;
        var layout = dialog.layout();
        var gb = new QGroupBox(qsTr("Passes"));
        layout.addWidget(gb, 1, 0)

        var layout2 = new QHBoxLayout();
        w = dialog.findChild("CamZPasses_Label");
        layout2.addWidget(w, 0, 0);
        w = dialog.findChild("CamZPasses");
        layout2.addWidget(w, 0, 0);
        layout2.addStretch();
        gb.setLayout(layout2);
    }

    if (dialog.objectName==="CamToolDialog") {
        // disable unused widgets:
        w = dialog.findChild("CamSpindleSpeed_Label");
        w.visible = false;
        w = dialog.findChild("CamSpindleSpeed");
        w.visible = false;
        w = dialog.findChild("CamSpindleSpeed_Unit");
        w.visible = false;

        w = dialog.findChild("CamPlungeRate");
        w.setText("0");
        w.visible = false;
        w = dialog.findChild("CamPlungeRate_Label");
        w.visible = false;
    }
};

FlskF2000IN.prototype.exportShape = function(shape) {
    // export spline as polyline with line segments instead of tangentially connected arc segments:
    if (isSplineShape(shape)) {
        // spline might be close approximation of line or arc:
        var lineArcSpline = ShapeAlgorithms.splineToLineOrArc(shape, this.getTolerance());
        if (isSplineShape(lineArcSpline)) {
            // convert spline to polyline with line segments:
            var splinePl = shape.toPolyline(2);
            this.exportShape(splinePl);
        }
        else {
            // spline closely resembles arc or line:
            this.exportShape(lineArcSpline);
        }
    }
    else {
        GCodeBase.prototype.exportShape.call(this, shape);
    }
};

FlskF2000IN.prototype.writeLine = function(line) {
    // skip empty lines:
    if (line!=="") {
        GCodeBase.prototype.writeLine.call(this, line);
    }
};
