/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeLaserOffset.js");

function GCodeLaserWeldingOffsetMM(documentInterface, camDocumentInterface) {
    GCodeLaserOffset.call(this, documentInterface, camDocumentInterface);

    this.decimals = 4;
    this.unit = RS.Millimeter;

    // disable line numbers:
    this.empty = "";
    this.registerVariable("empty", "N", true, "", 0);

    this.header = [
        "G54",
        "G58 X0 Y0",
        "M11"
    ];
    this.footer = [
        "G0 X0. Y0."
    ];

    this.alwaysWriteG1 = true;
}

GCodeLaserWeldingOffsetMM.prototype = new GCodeLaserOffset();
GCodeLaserWeldingOffsetMM.displayName = "G-Code Laser Welding (Offset) [mm]";
