/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

function SCM(cadDocumentInterface, camDocumentInterface) {
    GCodeBase.call(this, cadDocumentInterface, camDocumentInterface);
    // name,  ID,   always, prefix, decimals, options
    this.registerVariable("xPosition", "X", false, "X=", "DEFAULT", "DEFAULT");
    this.registerVariable("yPosition", "Y", false, "Y=", "DEFAULT", "DEFAULT");
    this.registerVariable("zPosition", "Z", false, "Z=", "DEFAULT", "DEFAULT");
    this.registerVariable("feedRate",            "F",                    false, "V=", 0);
    this.registerVariable("plungeRate",          "FP",                   false, "V=", 0);
    this.registerVariable("arcRadius",           "r",                    true,  "r=", "DEFAULT", "DEFAULT");
    this.registerVariable("tool",                "T",                    true,  "T=", 0);
    this.decimals = 2;
    /*this.options = {
        sign: true,
        decimalSeparator: ".",
        trailingZeroes: false
    };*/
    this.unit = RS.Millimeter;
    this.fileExtensions = [ "xxl" ];

    this.header = [
        "H DX=[X_MAX] DY=[Y_MAX] DZ=[Z_MAX] -A  /\"DEF\" C=0 T=16973824 R=99 *MM BX=0 BY=0 BZ=0 V=0",
        "; Job",
        "; Customer",
        "F=1",
        "O X=0 Y=0 Z=0 ;ChangePlane",
    ];

    this.footer = [
        "N X=0 Y=0"
    ];

    this.toolHeader = [];
    this.toolFooter = [];
    
    this.contourHeader = [];

    this.zPassFirstHeader = [];

    this.rapidMove = [];
    this.rapidMoveZ = [];

    this.firstLinearMove =           "G1 [X] [Y] [F]";
    this.firstLinearMoveZ = [];
    
    this.linearMove =                "G1 [X] [Y] [F]";
    this.linearMoveZ = [];

    this.splitArcsAtQuadrantLines = true;

    this.firstArcCWMove =            "G2 [X] [Y] [F] [r]";
    this.arcCWMove =                 "G2 [X] [Y] [F] [r]";

    this.firstArcCCWMove =           "G3 [X] [Y] [F] [r]";
    this.arcCCWMove =                "G3 [X] [Y] [F] [r]";

    this.linearMoveCompensationLeft = [
        "C=2",
        "G0 [X] [Y] [Z] [F] [T]" //OLD:"G41 [X] [Y]"
    ];
    this.linearMoveCompensationRight = [
        "C=1",
        "G0 [X] [Y] [Z] [F] [T]" //OLD:"G42 [X] [Y]"
    ];
    this.linearMoveCompensationOff = [
        "C=0", //OLD:"G40"
    ];

    // point moves for drilling:
     this.firstPointMoveZ = ["B [X] [Y] [Z] [F] [T]", ];
     this.pointMoveZ = []
      
    // command to execute after writing file:
         
     this.alwaysWriteG1 = true;
}

SCM.prototype = new GCodeBase();

SCM.prototype.writeFirstPointMoveZ = function() {
    if (this.zStartPosition < this.zPosition) {
        // disable all Z up moves:
        return;
    }
    else {
        this.writeBlock("firstPointMoveZ");
    }
};
SCM.displayName = "SCM";
