/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("GCodeBase.js");

/**
 * Base configuration for Mach3 controllers. 
 * Defines footer and compensation off move.
 */
function Mach3(documentInterface, camDocumentInterface) {
    GCodeBase.call(this, documentInterface, camDocumentInterface);

    // G28: Return home
    // G43: Apply offsets for this tool
    // H..: Position to use from tool table
    this.toolHeader = [
        "[N] G28",
        "[N] [T] M6 G43 H[T#]",
        "[N] [S] M03"
    ];

    // M09: All coolant off
    // M30: Program end and rewind
    // %: Comment, not executed (might be needed)
    this.footer = [
        "[N] M09",
        "[N] M30",
        "%"
    ];

    // Mach3 has G40 on separate line,
    // followed by a G1 with the position to move to:
    this.linearMoveCompensationOff = [
        "[N] G40",
        "[N] G1 [X] [Y]"
    ];
}

Mach3.prototype = new GCodeBase();
Mach3.displayName = "";
