/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */
include("UcCnc.js");

/**
 * Configuration for UCCNC controllers.
 * Output in Millimeters.
 */
function UcCncMM(documentInterface, camDocumentInterface) {
    UcCnc.call(this, documentInterface, camDocumentInterface);

    // G21: Millimeter unit
    // G17: XY Plane select
    // G90: Absolute distance mode
    // G40: Cancel cutter radius compensation
    // G49: Cancel tool length offset
    // G80: Cancel motion mode
    // G71: Millimeter unit
    // G91.1: Incremental distance mode for I/J
    this.header = [
        "(UCCNC)",
        "[N] G00 G21 G17 G90 G40 G49 G80",
        "[N] G71 G91.1",
    ];
}

UcCncMM.prototype = new UcCnc();
UcCncMM.displayName = "UCCNC (Offset) [mm]";
