/**
 * This file is part of the QCAD/CAM software.
 * Do NOT edit this file. Your changes will be lost when the software 
 * is updated or reinstalled. 
 * For details, please refer to the file README.txt in this directory.
 */

/**
 * Include definition of class CamExporterV2 from QCAD/CAM plugin:
 */
include("scripts/Cam/CamExportV2/CamExporterV2.js");

/**
 * This is a base class for G-Code configurations.
 * 
 * Do not edit this class. 
 * Instead, create your own derivation as shown in GodeMM.js, GCodeIN.js, ...
 */
function GCode2AxisPT(cadDocumentInterface, camDocumentInterface) {
    // call constructor of base class 'CamExporterV2':
    CamExporterV2.call(this, cadDocumentInterface, camDocumentInterface);

    if (isNull(cadDocumentInterface)) {
        // constructor used as prototype:
        return;
    }
	
	
	
	this.fileExtensions = [ "PT4" ];
	this.outputOffsetPath = false;
	
	this.decimals =6;
	this.options = { trailingZeroes:true };
    this.unit = RS.Millimeter;
	
	
	this.registerVariable("lineNumber",          "N",                    true,  "", 0);
    this.lineNumber = 3;
    this.lineNumberIncrement = 1;
	
	this.registerVariable("eventNumber",         "E",                    true,  "E", 0);
	this.eventNumber = 50;
    this.eventNumberIncrement = 1;
	
	
	
    // true to output computed offset path coordinates:
    this.outputOffsetPath = false;



    // home position
    // (can for example be used in header / footer or for tool changes):
    this.xHomePosition = 0;
    this.yHomePosition = 0;
    this.zHomePosition = 50;

    // Z levels:
    this.zClearance = 1.0;
    this.zCuttingDepth = -1.0;

    // true: split full circles in halves
    this.splitFullCircles = false;

    // true: always write G1, even if G mode does not change:
    this.alwaysWriteG1 = false;

    // line ending:
    this.lineEnding = "\n";



    // variables:
    //                    name,                  ID,                     always, prefix, decimals, options
    this.registerVariable("inputFileName",       "INFILENAME",           true,  "",  0);
    this.registerVariable("inputFilePath",       "INFILEPATH",           true,  "",  0);
    this.registerVariable("fileName",            "FILENAME",             true,  "",  0);
    this.registerVariable("filePath",            "FILEPATH",             true,  "",  0);
    this.registerVariable("dateTime",            "DATETIME",             true,  "",  0);

   
	
                                                                         
    this.registerVariable("spindleSpeed",        "S",                    true,  "", 6,"DEFAULT");
    this.registerVariable("feedRate",            "F",                    false, "F", 0);
    this.registerVariable("plungeRate",          "FP",                   false, "F", 0);
                                                                         
    this.registerVariable("xHomePosition",       "XH",                   true,  "X", "DEFAULT", "DEFAULT");
    this.registerVariable("yHomePosition",       "YH",                   true,  "Y", "DEFAULT", "DEFAULT");
    this.registerVariable("zHomePosition",       "ZH",                   true,  "Z", "DEFAULT", "DEFAULT");

    this.registerVariable("zSafety",             "ZS",                   true,  "Z", "DEFAULT", "DEFAULT");
    this.registerVariable("zClearance",          "ZU",                   true,  "Z", "DEFAULT", "DEFAULT");
    this.registerVariable("zClearancePass",      "ZUP",                  true,  "Z", "DEFAULT", "DEFAULT");
    this.registerVariable("zStart",              "Z_START",              true,  "Z", "DEFAULT", "DEFAULT");
    this.registerVariable("zEnd",                "Z_END",                true,  "Z", "DEFAULT", "DEFAULT");
    this.registerVariable("zCuttingDepth",       "ZD",                   true,  "ZD1", "DEFAULT", "DEFAULT");

    this.registerVariable("xFirstPosition",      "XF",                   true,  "X", "DEFAULT", "DEFAULT");
    this.registerVariable("yFirstPosition",      "YF",                   true,  "Y", "DEFAULT", "DEFAULT");

    this.registerVariable("xStartPosition",      "X1",                   true,  "", "DEFAULT", "DEFAULT");
    this.registerVariable("yStartPosition",      "Y1",                   true,  "", "DEFAULT", "DEFAULT");
    this.registerVariable("zStartPosition",      "Z1",                   true,  "", "DEFAULT", "DEFAULT");

    this.registerVariable("xPosition",           "X",                    false, "", "DEFAULT", "DEFAULT");
    this.registerVariable("yPosition",           "Y",                    false, "", "DEFAULT", "DEFAULT");
    this.registerVariable("zPosition",           "Z",                    false, "", "DEFAULT", "DEFAULT");

    this.registerVariable("xRelPosition",        "XR",                   true,  "X", "DEFAULT", "DEFAULT");
    this.registerVariable("yRelPosition",        "YR",                   true,  "Y", "DEFAULT", "DEFAULT");
    this.registerVariable("zRelPosition",        "ZR",                   true,  "Z", "DEFAULT", "DEFAULT");

    this.registerVariable("iArcCenterInc",       "I",                    true,  "I", "DEFAULT", "DEFAULT");
    this.registerVariable("jArcCenterInc",       "J",                    true,  "J", "DEFAULT", "DEFAULT");
    this.registerVariable("iArcCenterAbs",       "IA",                   true,  "I", "DEFAULT", "DEFAULT");
    this.registerVariable("jArcCenterAbs",       "JA",                   true,  "J", "DEFAULT", "DEFAULT");
    this.registerVariable("arcRadius",           "RADIUS",               true,  "", "DEFAULT", "DEFAULT");
    this.registerVariable("arcDiameter",         "DIAMETER",             true,  "", "DEFAULT", "DEFAULT");
    this.registerVariable("arcSweep",            "SWEEP",                true,  "", "DEFAULT", "DEFAULT");
                                                                         
    this.registerVariable("tool",                "T",                    true,  "", 0);
    this.registerVariable("toolRadius",          "TR",                   true,  "",  "DEFAULT", "DEFAULT");
    this.registerVariable("toolDiameter",        "TD",                   true,  "",  "DEFAULT", "DEFAULT");
                                                                                
    // Toolpath order: order number of toolpath (can be any number, increasing):
    this.registerVariable("toolpathOrder",       "TOOLPATH_ORDER",       true,  "",  0);

    // Toolpath index: index of toolpath (0, 1, 2, ...):
    this.registerVariable("toolpathIndex",       "TOOLPATH_INDEX",       true,  "",  0);
    //this.registerVariable("toolpathIndex1",      "TOOLPATH_INDEX_1",     true,  "",  0);

    // Tool calls: number of calls for current tool, starting with 1
    this.registerVariable("toolCalls",           "TOOL_CALLS",           true,  "",  0);

    this.registerVariable("toolpathName",        "TOOLPATH_NAME",        true,  "",  0);
    this.registerVariable("programName",         "PROGRAM_NAME",         true,  "",  0);

    this.registerVariable("xMin",                "X_MIN",                true,  "",  "DEFAULT", "DEFAULT");
    this.registerVariable("xMax",                "X_MAX",                true,  "",  "DEFAULT", "DEFAULT");
    this.registerVariable("yMin",                "Y_MIN",                true,  "",  "DEFAULT", "DEFAULT");
    this.registerVariable("yMax",                "Y_MAX",                true,  "",  "DEFAULT", "DEFAULT");
    this.registerVariable("zMin",                "Z_MIN",                true,  "",  "DEFAULT", "DEFAULT");
    this.registerVariable("zMax",                "Z_MAX",                true,  "",  "DEFAULT", "DEFAULT");


    this.header = [
"--------------------------",
"SECTION		HEADER",
"--------------------------",
"BEGREC		1",
"NAME		    D:\[FILENAME]",
"VERSION		5.11 (103114.09 1980)",
"FIRMWARE	SLV 4.6.7 SX    ",
"PRODUCT		54	PROTOTRAK SX",
"SCALE		1.000000",
"METRIC_DISPLAY	0",
"USE_DWELL	0",
"USE_AUX		0",
"USE_COMMENTS	0",
"IS_TOOLPATH	0",
"IS_SPINDLEOFF	1",
"EVENT_GROUP	2",
"X_HOME		0.000000",
"Y_HOME		0.000000",
"USE_FIXTURE		0",
"ENDREC		",
"ENDS",
"--------------------------",
"SECTION		TOOLTABLE",
"--------------------------",
"BEGREC		2",
"TOOL		1",
"TYPE		14",
"DIAMETER	2.997200",
"ZOFFSET		0.000000",
"ZMOD		0.000000",
"ENDREC		",
"--------------------------",
"ENDS",
"--------------------------",
"SECTION		FIXTURETABLE",
"--------------------------",
"ENDS",
"--------------------------",
"SECTION		EVENTS"
    ];


    this.toolHeader = [];
	
	
	
	
	
 // point moves for drilling:
   this.rapidMove =             [
"--------------------------",
"BEGREC	            	[N]",
"EVENT		[E]", 
"TYPE		1	POSN DRILL",
"OK		1",
"XEND		  [X]A      ",       
"YEND		  [Y]A         ",       
"ZEND		0.000000A",
"ZRAPID		0.000000A",
"TOOL		1",
"RPM		  [S]     ",                     
"CONTINUE	0",
"AUXBEG		0",
"AUXEND		0",
"COMMENT		",
"FIXTURE		0",
"ENDREC		"
]







this.footer = [
"--------------------------",
"ENDS"
]


// linear Z moves:
    this.firstLinearMoveZ =  [];
    this.linearMoveZ =  [];





    // command to execute after writing file:
    this.runCommand = "";










    this.alwaysWriteG1 = false;

    this.debugging = false;
}

/**
 * Configuration 'GCode2AxisPT' is derived from class 'CamExporterV2'. All configurations
 * _must_ be (directly or indirectly) derived from CamExporterV2 to be valid configurations.
 */
GCode2AxisPT.prototype = new CamExporterV2();
GCode2AxisPT.displayName = "GCode2AxisPT";

GCode2AxisPT.prototype.postInit = function(dialog) {
    var ret = CamExporterV2.prototype.postInit.call(this, dialog);

    if (this.alwaysWriteG1===true) {
        this.cadDocument.setVariable(Cam.getCurrentVariablePrefix() + "AlwaysWriteG1", true);
    }

    // save original text blocks for skipping G1:
    // needed to restore if always write G1 is switched off:
    if (isNull(this.linearMoveOri)) {
        this.linearMoveOri = this.linearMove;
        this.linearMoveZOri = this.linearMoveZ;
        this.pointMoveZOri = this.pointMoveZ;
    }

    return ret;
};

GCode2AxisPT.prototype.initConfigDialog = function(dialog) {
    // add options for laser on / off:
    var group = dialog.findChild("GroupCustom");
    group.title = qsTr("G-Code");

    // get QVBoxLayout:
    var vBoxLayout = group.layout();

    // add checkbox to force G1:
    var hBoxLayout = new QHBoxLayout(null);
    vBoxLayout.addLayout(hBoxLayout, 0);

    var cbAlwaysWriteG1 = new QCheckBox(qsTr("Always write G1"));
    cbAlwaysWriteG1.objectName = "AlwaysWriteG1";
    hBoxLayout.addWidget(cbAlwaysWriteG1, 0,0);
};

GCode2AxisPT.prototype.writeFile = function(fileName) {
    if (this.getGlobalOption("AlwaysWriteG1", false)===true) {
        this.linearMove = this.firstLinearMove;
        this.linearMoveZ = this.firstLinearMoveZ;
        this.pointMoveZ = this.firstPointMoveZ;
    }
    else {
        this.linearMove = this.linearMoveOri;
        this.linearMoveZ = this.linearMoveZOri;
        this.pointMoveZ = this.pointMoveZOri;
    }

    return CamExporterV2.prototype.writeFile.call(this, fileName);
};


/*
GCode2AxisPT.prototype.writeBlockFromString = function(blockStrings) {
    if (isNull(blockStrings)) {
        return;
    }

    if (isString(blockStrings)) {
        blockStrings = [ blockStrings ];
    }

    // detect usage of [E]
    var incE = false;
    for (var i=0; i<blockStrings.length; i++) {
        // blockString
        // e.g. "[N] G01 [X] [Y]"
        var blockString = blockStrings[i];
        if (blockString.contains("[E]")) {
            // a block string contains variable [E], increment after writing
            incE = true;
        }
    }

    // write block strings:
    CamExporterV2.prototype.writeBlockFromString.call(this, blockStrings);

    if (incE) {
        this.eventNumber+=this.eventNumberIncrement;
    }
};
*/

GCode2AxisPT.prototype.variableUsed = function(id, value) {
    if (id==="E") {
        this.eventNumber+=this.eventNumberIncrement;
    }
};
